<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Skill;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

abstract class BaseController extends Controller
{
         abstract protected function getModelClass();
            public $table_name;
   
   public function __construct($table_name) {
       $this->table_name = $table_name;
   }
    public function index(Request $request)
    {
 
        
        
        //
        if ($request->ajax()) {
            $data = $this->getModelClass()::latest()->get();
            return Datatables::of($data)
                    ->addIndexColumn()
                    ->addColumn('action', function($row){
   
                           $btn = '<a href="javascript:void(0)" data-toggle="tooltip" '
                                   . ' data-id="'.$row->id.'" data-original-title="Edit" class="edit btn btn-info  btn-sm  editSkill"><i class="fa fa-edit"></i> Edit</a>';
   
                           $btn = $btn.' <a href="javascript:void(0)" data-toggle="tooltip"'
                                   . ' data-id="'.$row->id.'" data-original-title="Delete" class="btn btn-danger  btn-sm  deleteSkill"><i class="fa fa-multiply"></i> Delete</a>';
    
                            return $btn;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
                    return view('dashboard.pages.'.$this->table_name.'s',compact('data'));
        }
      
        return view('dashboard.pages.universal' ,['pivot'=>$this->table_name]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->getModelClass()::create([
              
                'name' => $request->name,
              
        ]);        
   
        return response()->json(['success'=>'Product saved successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Skill  $skill
     * @return \Illuminate\Http\Response
     */
    public function show(Skill $skill)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Skill  $skill
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
         $product = $this->getModelClass()::find($id);
        return response()->json($product);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Skill  $skill
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $product = $this->getModelClass()::find($id)->update([
                'name' => $request->name,
        ]);
        return response()->json($product);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Skill  $skill
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->getModelClass()::find($id)->delete();
     
        return response()->json(['success'=>'Product deleted successfully.']);
    }
}