<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Goal
 * 
 * @property int $id
 * @property string|null $name
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Collection|Question[] $questions
 *
 * @package App\Models
 */
class Goal extends Model
{
	protected $table = 'goals';

	protected $fillable = [
		'name'
	];

	public function questions()
	{
		return $this->hasMany(Question::class);
	}
}
