<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Multimedia
 * 
 * @property int $id
 * @property string|null $thumb_url
 * @property string|null $original_url
 * @property int|null $media_type
 * @property int|null $target_id
 * @property int|null $target_type
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property int|null $order_sn
 *
 * @package App\Models
 */
class Multimedia extends Model
{
	protected $table = 'multimedia';

	protected $casts = [
		'media_type' => 'int',
		'target_id' => 'int',
		'target_type' => 'int',
		'order_sn' => 'int'
	];

	protected $fillable = [
		'thumb_url',
		'original_url',
		'media_type',
		'target_id',
		'target_type',
		'order_sn'
	];
}
