<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class QuestionOption
 * 
 * @property int $id
 * @property int|null $question_id
 * @property int|null $option_type
 * @property string|null $option_text
 * @property int|null $order_sn
 * @property int|null $is_correct
 * 
 * @property Question|null $question
 *
 * @package App\Models
 */
class QuestionOption extends Model
{
	protected $table = 'question_options';
	public $timestamps = false;

	protected $casts = [
		'question_id' => 'int',
		'option_type' => 'int',
		'order_sn' => 'int',
		'is_correct' => 'int'
	];

	protected $fillable = [
		'question_id',
		'option_type',
		'option_text',
		'order_sn',
		'is_correct'
	];

	public function question()
	{
		return $this->belongsTo(Question::class);
	}
}
