<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class UsersAnswer
 * 
 * @property int $id
 * @property int|null $user_id
 * @property int|null $question_id
 * @property string|null $user_answer
 * @property int|null $is_correct
 * @property int|null $is_submitted
 * @property float|null $score
 * @property Carbon|null $eval_date
 * @property int|null $evaluated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property int|null $grade_id
 * @property string|null $section
 * @property int|null $school_id
 * @property string|null $correct_answer
 * 
 * @property Question|null $question
 *
 * @package App\Models
 */
class UsersAnswer extends Model
{
	protected $table = 'users_answers';

	protected $casts = [
		'user_id' => 'int',
		'question_id' => 'int',
		'is_correct' => 'int',
		'is_submitted' => 'int',
		'score' => 'float',
		'eval_date' => 'datetime',
		'evaluated_by' => 'int',
		'grade_id' => 'int',
		'school_id' => 'int'
	];

	protected $fillable = [
		'user_id',
		'question_id',
		'user_answer',
		'is_correct',
		'is_submitted',
		'score',
		'eval_date',
		'evaluated_by',
		'grade_id',
		'section',
		'school_id',
		'correct_answer'
	];

	public function question()
	{
		return $this->belongsTo(Question::class);
	}
}
