<!DOCTYPE html>
<html
  lang="en"
  class="light-style layout-menu-fixed"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="{{url('dashboard')}}/assets/"
  data-template="vertical-menu-template-free"
>
  <head>
          <title>Katapa dashboard :: {{$pivot}}s</title>
   @include('dashboard.shared.meta')
   @include('dashboard.shared.css')

  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        @include('dashboard.shared.menu')
        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

        @include('dashboard.shared.nav')
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
           
                
                   
<div class="">

    <a class="btn btn-success btn-sm " href="javascript:void(0)" style="float: right" id="createNewSkill">
        <i class="fa fa-plus"></i>
        Add New {{$pivot}}</a>
    <p class="h5" style="color: green;">Current {{$pivot}}s</p>
    <div class="p-2"></div>
    
        
    <!-- Bootstrap Table with Header - Light -->
              <div class=" p-2 table-responsive">
    <table class="table table-bordered " id="data-table">
        <thead style="background-color: #f2f2f2;">
            <tr>
            
                <th style="font-weight: bold">Title</th>
                <th style="max-width: 220px;font-weight: bold">Actions</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
              </div>
</div>
   
<div class="modal fade" id="ajaxModelexa" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-name" id="modelHeading"></h4>
            </div>
            <div class="modal-body">
                <form id="skillForm" name="skillForm" class="form-horizontal">
                   <input type="hidden" name="id" id="id">
                    <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Title</label>
                        <div class="col-sm-12">
                            <input type="text" class="form-control" id="name" name="name" placeholder="Enter Name" value="" required>
                        </div>
                    </div>
     
               
      
                    <div class="col-sm-offset-2 col-sm-10">
                     <button type="submit" class="btn btn-primary" id="savedata" value="create">Save {{$pivot}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
    

  
                
            </div>
            <!-- / Content -->

          @include('dashboard.shared.footer')
            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

   @include('dashboard.shared.js')
   
       
<script type="text/javascript">
   
    $(document).ready(function() { 
     
      $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
    });
    
    var table = $('#data-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route($pivot.'s.index') }}",
        columns: [
          
            {data: 'name', name: 'name'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
     
    $('#createNewSkill').click(function () {
        $('#savedata').html("Create {{$pivot}}");
        $('#id').val('');
        $('#skillForm').trigger("reset");
        $('#modelHeading').html("Create New {{$pivot}}");
        $('#ajaxModelexa').modal('show');
    });
    
    $('body').on('click', '.editSkill', function () {
      var id = $(this).data('id');
      $.get("{{ route($pivot.'s.index') }}" +'/' + id +'/edit', function (data) {
          $('#modelHeading').html("Edit {{$pivot}}");
          $('#savedata').html("Edit {{$pivot}}");
          $('#ajaxModelexa').modal('show');
          $('#id').val(data.id);
          $('#name').val(data.name);
      
      })
   });
    
    $('#savedata').click(function (e) {
        e.preventDefault();
        let action = $(this).html() == 'Edit {{$pivot}}' ? 'edit' : 'create';
        $(this).html('Sending..');
    
        $.ajax({
          data: $('#skillForm').serialize(),
          url:  action == 'create' ?  "{{ route($pivot.'s.store') }}" :  "{{ url($pivot.'s') }}/" +$('#id').val() ,
          type: action == 'create' ? "POST"  : "PUT",
          dataType: 'json',
          success: function (data) {
     
              $('#skillForm').trigger("reset");
              $('#ajaxModelexa').modal('hide');
              table.draw();
         
          },
          error: function (data) {
              console.log('Error:', data);
              $('#savedata').html('Save Changes');
          }
      });
    });
    
    $('body').on('click', '.deleteSkill', function () {
     
        var id = $(this).data("id");
        if(!confirm("Are You sure want to delete this {{$pivot}} ?"))return;
      
        $.ajax({
            type: "DELETE",
            url: "{{ route($pivot.'s.store') }}"+'/'+id,
            success: function (data) {
                table.draw();
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
    });
     
  });
</script>
              
  </body>
</html>
